/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWConfirmRefreshDialog;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWStepNParticipantRenderer;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class VWCompleteWorkDialog
extends VWModalDialog
implements IVWPropertyChangeListener {
    VWTrkDataModel m_trackerDataModel = null;
    VWStepNParticipantRenderer m_stepAndParticipantRenderer = new VWStepNParticipantRenderer();
    private Vector m_activeSteps = null;
    private Object m_selected = null;
    private VWTrkStepOccurrence m_occurrence = null;
    private String m_queueName = null;
    private JLabel m_stepLabel = null;
    private JComboBox m_stepCombo = null;
    private DefaultComboBoxModel m_stepModel = null;
    private JLabel m_participantsLabel = null;
    private JList m_participantList = null;
    private DefaultListModel m_participantModel = null;
    private JLabel m_workQueueLabel = null;
    private JLabel m_queueNameUI = null;
    private JLabel m_responseLabel = null;
    private JComboBox m_responseCombo = null;
    private DefaultComboBoxModel m_responseModel = null;
    private String[] m_responses = null;
    private String m_selectedResponse = null;
    private String m_selecteAResponse = VWResource.s_selectAResponse;
    private String m_variousResponses = VWResource.s_variousResponses;
    private String m_nullResponseString = null;
    private boolean m_bMissingResponse = false;
    private JLabel m_commentsLabel = null;
    private JTextArea m_commentsUI = null;
    private JTextArea m_newCommentsUI = null;
    private String m_comments = "";
    private JRadioButton m_appendRadio = null;
    private JRadioButton m_replaceRadio = null;
    private JButton m_okButton = null;
    private JButton m_applyButton = null;
    private boolean m_bCanceled = true;
    private boolean m_bInitializing = false;
    private VWLockWork m_lockWork = null;

    public VWCompleteWorkDialog(Frame parent, VWTrkDataModel trackerDataModel) throws Exception {
        super(parent);
        this.m_trackerDataModel = trackerDataModel;
        if (trackerDataModel == null) {
            throw new Exception(VWResource.s_nullTrackerDataModel.toString(VWResource.s_completeWorkDialogTitle));
        }
        this.initData();
        this.setupLayout();
        this.updateControls();
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
        Vector selectedSteps = trackerDataModel.getSelectedSteps();
        if (selectedSteps != null && selectedSteps.size() > 0 && this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < selectedSteps.size(); ++i) {
                Object obj = selectedSteps.elementAt(i);
                if (obj == null || this.m_stepModel.getIndexOf(obj) < 0) continue;
                Object selected = this.m_stepModel.getSelectedItem();
                if (selected == obj) break;
                this.m_stepModel.setSelectedItem(obj);
                break;
            }
        }
    }

    protected void initData() {
        Object selected = null;
        this.m_activeSteps = this.m_trackerDataModel.getActiveSteps();
        this.m_bInitializing = true;
        if (this.m_stepModel == null) {
            this.m_stepModel = new DefaultComboBoxModel();
        } else {
            this.m_stepModel.removeAllElements();
        }
        if (this.m_activeSteps != null && this.m_activeSteps.size() > 0) {
            for (int i = 0; i < this.m_activeSteps.size(); ++i) {
                Vector occurrences;
                Object obj = this.m_activeSteps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStep) || (occurrences = ((VWTrkStep)obj).getActiveOccurrences()) == null) continue;
                if (occurrences.size() == 1) {
                    this.m_stepModel.addElement(obj);
                    if (this.m_selected == null || this.m_selected != obj) continue;
                    selected = obj;
                    this.m_selected = null;
                    continue;
                }
                for (int j = 0; j < occurrences.size(); ++j) {
                    obj = occurrences.elementAt(j);
                    if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                    this.m_stepModel.addElement(obj);
                    if (this.m_selected == null || this.m_selected != obj) continue;
                    selected = obj;
                    this.m_selected = null;
                }
            }
            if (selected == null) {
                selected = this.m_stepModel.getElementAt(0);
            }
            this.m_stepModel.setSelectedItem(selected);
        } else {
            selected = null;
        }
        this.initStep(selected);
        this.m_bInitializing = false;
    }

    private void initParticipants() {
        Vector participants = null;
        participants = this.m_occurrence != null ? this.m_occurrence.getActiveParticipants() : null;
        if (this.m_participantModel == null) {
            this.m_participantModel = new DefaultListModel();
        } else {
            this.m_participantModel.removeAllElements();
        }
        if (this.m_participantList != null) {
            this.m_participantList.removeSelectionInterval(0, this.m_participantModel.getSize() - 1);
        }
        this.m_queueName = null;
        if (participants != null && participants.size() > 0) {
            for (int i = 0; i < participants.size(); ++i) {
                Object obj = participants.elementAt(i);
                if (!(obj instanceof VWTrkParticipant)) continue;
                VWTrkParticipant participant = (VWTrkParticipant)obj;
                if (this.m_queueName == null) {
                    this.m_queueName = participant.getQueueName();
                }
                if (participant.isLockedByOther()) continue;
                int loc = this.m_participantModel.size();
                VWParticipant vwParticipant = participant.getParticipant();
                if (vwParticipant == null || vwParticipant.getParticipantName() == null) {
                    loc = 0;
                } else {
                    for (int j = 0; j < this.m_participantModel.size(); ++j) {
                        VWTrkParticipant p = (VWTrkParticipant)this.m_participantModel.getElementAt(j);
                        VWParticipant tempParticipant = p.getParticipant();
                        if (tempParticipant == null || tempParticipant.getParticipantName() == null || VWStringUtils.compareIgnoreCase(vwParticipant.getParticipantName(), tempParticipant.getParticipantName()) > 0) continue;
                        loc = j;
                        break;
                    }
                }
                if (loc >= this.m_participantModel.size()) {
                    this.m_participantModel.addElement(participant);
                    continue;
                }
                this.m_participantModel.insertElementAt(participant, loc);
            }
        }
    }

    private void initResponses() {
        Object obj;
        String selectedResponse = null;
        if (this.m_responseCombo != null && (obj = this.m_responseCombo.getSelectedItem()) instanceof String) {
            selectedResponse = (String)obj;
        }
        if (this.m_selected != null) {
            VWTrkStep step = null;
            if (this.m_selected instanceof VWTrkStep) {
                step = (VWTrkStep)this.m_selected;
            } else if (this.m_selected instanceof VWTrkStepOccurrence) {
                step = ((VWTrkStepOccurrence)this.m_selected).getStep();
            }
            if (step != null) {
                if (!step.isComponentStep()) {
                    this.m_responses = step.getStepDefinition() != null ? step.getStepDefinition().getResponses() : null;
                }
            } else {
                this.m_responses = null;
            }
        } else {
            this.m_responses = null;
        }
        if (this.m_responseModel == null) {
            this.m_responseModel = new DefaultComboBoxModel();
        } else {
            this.m_responseModel.removeAllElements();
        }
        if (this.m_responses != null && this.m_responses.length > 0) {
            int i;
            for (i = 0; i < this.m_responses.length; ++i) {
                this.m_responseModel.addElement(this.m_responses[i]);
            }
            if (selectedResponse != null) {
                for (i = 0; i < this.m_responses.length; ++i) {
                    if (VWStringUtils.compare(selectedResponse, this.m_responses[i]) != 0) continue;
                    this.m_responseModel.setSelectedItem(this.m_responses[i]);
                    break;
                }
            }
        }
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_completeWorkDialogDim);
        if (dim == null) {
            dim = new Dimension(450, 400);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_completeWorkDialogTitle);
        this.m_stepLabel = new JLabel(VWResource.s_label.toString(VWResource.s_step));
        this.m_stepCombo = new JComboBox(this.m_stepModel);
        this.m_stepCombo.setRenderer(this.m_stepAndParticipantRenderer);
        this.m_workQueueLabel = new JLabel(VWResource.s_label.toString(VWResource.s_queue));
        this.m_queueNameUI = new JLabel("");
        this.m_participantsLabel = new JLabel(VWResource.s_label.toString(VWResource.s_participants));
        if (this.m_participantModel == null) {
            this.m_participantModel = new DefaultListModel();
        }
        this.m_participantList = new JList(this.m_participantModel);
        this.m_participantList.setCellRenderer(this.m_stepAndParticipantRenderer);
        this.m_responseLabel = new JLabel(VWResource.s_label.toString(VWResource.s_response));
        if (this.m_responseModel == null) {
            this.m_responseModel = new DefaultComboBoxModel();
        }
        this.m_responseCombo = new JComboBox(this.m_responseModel);
        this.m_responseCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWCompleteWorkDialog.this.setButtonState();
            }
        });
        this.m_responseCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                ((JLabel)component).setText("");
                ((JLabel)component).setIcon(null);
                if (value != null) {
                    if (value instanceof String) {
                        ((JLabel)component).setText((String)value);
                    }
                } else {
                    ((JLabel)component).setText(VWCompleteWorkDialog.this.m_nullResponseString);
                }
                return component;
            }
        });
        this.m_commentsLabel = new JLabel(VWResource.s_label.toString(VWResource.s_comments));
        this.m_commentsUI = new JTextArea();
        this.m_commentsUI.setLineWrap(true);
        this.m_commentsUI.setWrapStyleWord(false);
        this.m_commentsUI.setEditable(false);
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_applyButton = new JButton(VWResource.s_apply);
        JButton cancelButton = new JButton(VWResource.s_close);
        JButton helpButton = new JButton(VWResource.s_help);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JPanel participantsPanel = new JPanel();
        this.setupParticipantsPanel(participantsPanel);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 3.0;
        c.fill = 1;
        c.insets = new Insets(6, 0, 0, 0);
        mainPanel.add((Component)participantsPanel, c);
        JPanel commentsPanel = new JPanel();
        this.setupCommentsPanel(commentsPanel);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 3.0;
        c.fill = 1;
        c.insets = new Insets(6, 0, 0, 0);
        mainPanel.add((Component)commentsPanel, c);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_applyButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(helpButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.m_stepCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (VWCompleteWorkDialog.this.m_bInitializing) {
                    return;
                }
                if (e.getStateChange() == 1) {
                    VWCompleteWorkDialog.this.performStepSelected();
                }
            }
        });
        this.m_participantList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                VWCompleteWorkDialog.this.setButtonState();
                VWCompleteWorkDialog.this.updateCommentsAndResponse();
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWCompleteWorkDialog.this.m_bCanceled = false;
                VWCompleteWorkDialog.this.performCompleteWork();
                VWCompleteWorkDialog.this.setVisible(false);
                VWCompleteWorkDialog.this.removePropertyChangeListener();
            }
        });
        this.m_applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWCompleteWorkDialog.this.performCompleteWork();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWCompleteWorkDialog.this.m_bCanceled = true;
                VWCompleteWorkDialog.this.setVisible(false);
                VWCompleteWorkDialog.this.removePropertyChangeListener();
            }
        });
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt035.htm");
            }
        });
        this.updateCommentsAndResponse();
    }

    private void setupParticipantsPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        c.fill = 1;
        c.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.m_stepLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        panel.add((Component)this.m_stepCombo, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        panel.add((Component)this.m_workQueueLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        panel.add((Component)this.m_queueNameUI, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 23;
        c.fill = 0;
        panel.add((Component)this.m_participantsLabel, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 2.0;
        panel.add((Component)new JScrollPane(this.m_participantList), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)this.m_responseLabel, c);
        c.gridx = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        panel.add((Component)this.m_responseCombo, c);
    }

    private void setupCommentsPanel(JPanel panel) {
        this.m_commentsUI = new JTextArea();
        this.m_commentsUI.setLineWrap(true);
        this.m_commentsUI.setWrapStyleWord(false);
        this.m_newCommentsUI = new JTextArea();
        this.m_newCommentsUI.setLineWrap(true);
        this.m_newCommentsUI.setWrapStyleWord(false);
        ButtonGroup grp = new ButtonGroup();
        this.m_appendRadio = new JRadioButton(VWResource.s_append);
        this.m_replaceRadio = new JRadioButton(VWResource.s_replace);
        grp.add(this.m_appendRadio);
        grp.add(this.m_replaceRadio);
        this.m_appendRadio.setSelected(true);
        this.m_replaceRadio.setSelected(false);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_label.toString(VWResource.s_comments)));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.insets = new Insets(0, 6, 0, 0);
        panel.add((Component)this.m_appendRadio, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 10;
        panel.add((Component)this.m_replaceRadio, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.anchor = 23;
        c.fill = 0;
        panel.add((Component)new JLabel(VWResource.s_currentComments), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_commentsUI), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        panel.add((Component)new JLabel(VWResource.s_enterComments), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_newCommentsUI), c);
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_stepLabel.setFont(boldFont);
            this.m_workQueueLabel.setFont(boldFont);
            this.m_participantsLabel.setFont(boldFont);
        }
    }

    private void updateControls() {
        if (this.m_selected != null) {
            if (this.m_queueName != null) {
                this.m_queueNameUI.setText(this.m_queueName);
            } else {
                this.m_queueNameUI.setText("");
            }
            boolean bResponses = this.m_responseModel.getSize() > 0;
            this.m_responseLabel.setVisible(bResponses);
            this.m_responseCombo.setVisible(bResponses);
        } else {
            this.m_queueNameUI.setText("");
            this.m_workQueueLabel.setEnabled(false);
            this.m_queueNameUI.setEnabled(false);
            this.m_participantsLabel.setEnabled(false);
            this.m_participantList.setEnabled(false);
        }
        this.setButtonState();
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    private void performStepSelected() {
        Object obj = this.m_stepCombo.getSelectedItem();
        if (obj != this.m_selected) {
            this.initStep(obj);
            this.updateCommentsAndResponse();
            this.updateControls();
        }
    }

    private void updateCommentsAndResponse() {
        if (this.m_participantList == null) {
            if (this.m_responseCombo != null) {
                this.m_responseCombo.setEnabled(false);
            }
            this.m_nullResponseString = "";
            return;
        }
        this.m_comments = "";
        this.m_selectedResponse = "";
        boolean bVariousResponse = false;
        boolean bVariousComments = false;
        VWTrkParticipant participant = null;
        Object[] selection = this.m_participantList.getSelectedValues();
        int selectedRespIndex = -1;
        if (selection != null && selection.length > 0) {
            int i;
            this.m_commentsUI.setEditable(false);
            this.m_responseCombo.setEnabled(true);
            this.m_bMissingResponse = false;
            for (i = 0; i < selection.length; ++i) {
                Object obj = selection[i];
                if (obj instanceof VWTrkParticipant) {
                    participant = (VWTrkParticipant)obj;
                }
                if (!bVariousComments) {
                    String comments = null;
                    try {
                        comments = participant.getComments();
                    }
                    catch (VWException ex) {
                        // empty catch block
                    }
                    if (this.m_comments == null || this.m_comments.length() == 0) {
                        this.m_comments = comments;
                    } else if (comments == null || VWStringUtils.compare(this.m_comments, comments) != 0) {
                        bVariousComments = true;
                        this.m_comments = null;
                    }
                }
                String response = null;
                try {
                    response = participant.getResponse();
                }
                catch (VWException ex) {
                    // empty catch block
                }
                if (response == null) {
                    this.m_bMissingResponse = true;
                }
                if (bVariousResponse) continue;
                if (this.m_selectedResponse == null || this.m_selectedResponse.length() == 0) {
                    this.m_selectedResponse = response;
                    continue;
                }
                if (response != null && VWStringUtils.compare(this.m_selectedResponse, response) == 0) continue;
                bVariousResponse = true;
                this.m_selectedResponse = null;
            }
            if (this.m_selectedResponse != null && this.m_responses != null) {
                for (i = 0; i < this.m_responses.length; ++i) {
                    if (this.m_responses[i] == null || VWStringUtils.compare(this.m_selectedResponse, this.m_responses[i]) != 0) continue;
                    selectedRespIndex = i;
                }
            } else {
                selectedRespIndex = -1;
                this.m_nullResponseString = bVariousResponse ? this.m_variousResponses : this.m_selecteAResponse;
            }
            if (this.m_comments == null) {
                this.m_comments = VWResource.s_variousComments;
            }
        } else {
            this.m_responseCombo.setEnabled(false);
            this.m_nullResponseString = "";
        }
        this.m_commentsUI.setText(this.m_comments);
        this.m_responseCombo.setSelectedIndex(selectedRespIndex);
        this.m_responseCombo.updateUI();
    }

    private void setButtonState() {
        boolean bEnable = false;
        int[] selection = this.m_participantList.getSelectedIndices();
        if (selection != null && selection.length > 0) {
            bEnable = true;
        }
        if (bEnable && this.m_responses != null && this.m_responses.length > 0) {
            bEnable = !this.m_bMissingResponse || this.m_responseCombo.getSelectedIndex() != -1;
        }
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private boolean confirmCompleteWork() {
        int option = JOptionPane.showConfirmDialog(this, VWResource.s_areYouSureCompleteWork, VWResource.s_completeWorkDialogTitle, 0, 3);
        return option == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCompleteWork() {
        if (!this.confirmCompleteWork()) {
            return;
        }
        try {
            boolean bAnyFailed = false;
            boolean bAnySucceeded = false;
            VWTrkParticipant participant = null;
            String response = null;
            String newComments = this.m_newCommentsUI.getText();
            String comments = null;
            boolean bAppendComments = this.m_appendRadio.isSelected();
            boolean bVariousResponses = false;
            Object[] selectedParticipants = this.m_participantList.getSelectedValues();
            if (selectedParticipants != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                boolean bLocked = true;
                try {
                    this.m_lockWork = new VWLockWork((Dialog)this, this.m_trackerDataModel, selectedParticipants);
                    bLocked = this.m_lockWork.isSuccess();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_completeWorkDialogTitle, 0, null);
                    this.m_lockWork = null;
                }
                if (bLocked) {
                    boolean bl = bVariousResponses = this.m_responseCombo.getSelectedIndex() < 0;
                    if (!bVariousResponses) {
                        response = (String)this.m_responseCombo.getSelectedItem();
                    }
                    for (int i = 0; i < selectedParticipants.length; ++i) {
                        participant = (VWTrkParticipant)selectedParticipants[i];
                        if (bAppendComments) {
                            try {
                                comments = participant.getComments();
                            }
                            catch (VWException ex) {
                                // empty catch block
                            }
                            if (comments == null) {
                                comments = "";
                            }
                            if (newComments != null && newComments.length() > 0) {
                                if (comments.length() > 0) {
                                    comments = comments + "\n";
                                }
                                comments = comments + newComments;
                            }
                        } else {
                            comments = newComments != null ? newComments : null;
                        }
                        if (bVariousResponses) {
                            try {
                                response = participant.getResponse();
                            }
                            catch (VWException ex) {
                                response = null;
                            }
                        }
                        try {
                            VWWorkObject wob = participant.getWork().getWorkObject().getVWWorkObject();
                            if (wob != null && wob.getIsTracker() && (wob.getParticipantName() == null || VWStringUtils.compare(wob.getParticipantName(), "(NONE)") == 0) && VWStringUtils.compare(wob.getLastErrorNumber(), "0") != 0) {
                                String queueName = wob.getCurrentQueueName();
                                String wobNum = wob.getWorkObjectNumber();
                                participant.doTerminate();
                                VWWorkObject vwWorkObject = null;
                                vwWorkObject = this.m_trackerDataModel.fetchInitialWorkObject(queueName, wobNum);
                                if (vwWorkObject != null) {
                                    vwWorkObject.doLock(true);
                                    vwWorkObject.doTerminate();
                                }
                            } else {
                                participant.doComplete(response, comments);
                            }
                            bAnySucceeded = true;
                            continue;
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_completeWorkDialogTitle, 0, null);
                            bAnyFailed = true;
                        }
                    }
                } else {
                    if (this.m_lockWork != null) {
                        this.m_lockWork.unlock();
                    }
                    JOptionPane.showMessageDialog(this, VWResource.s_someCantBeLocked, VWResource.s_completeWorkDialogTitle, 0, null);
                }
                this.setCursor(null);
            }
            if (bAnySucceeded) {
                boolean bSave = true;
                if (this.m_trackerDataModel.isAltered()) {
                    VWConfirmRefreshDialog confirmRefreshDialog = new VWConfirmRefreshDialog((Dialog)this, false);
                    confirmRefreshDialog.setVisible(true);
                    bSave = confirmRefreshDialog.isYes();
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.m_trackerDataModel.refresh(bSave);
                this.setCursor(null);
            }
            if (bAnyFailed) {
                if (bAnySucceeded) {
                    JOptionPane.showMessageDialog(this, VWResource.s_someFailedToComplete, VWResource.s_completeWorkDialogTitle, 0, null);
                } else {
                    JOptionPane.showMessageDialog(this, VWResource.s_failedToComplete, VWResource.s_completeWorkDialogTitle, 0, null);
                }
            }
        }
        finally {
            this.setCursor(null);
            this.m_newCommentsUI.setText(null);
        }
    }

    private void initStep(Object selected) {
        if (selected == null) {
            this.m_selected = null;
            this.initParticipants();
            this.initResponses();
            this.updateCommentsAndResponse();
            return;
        }
        if (this.m_selected == selected) {
            return;
        }
        if (!(selected instanceof VWTrkStep) && !(selected instanceof VWTrkStepOccurrence)) {
            return;
        }
        this.m_selected = selected;
        if (this.m_selected instanceof VWTrkStep) {
            Vector occurrences = ((VWTrkStep)this.m_selected).getActiveOccurrences();
            if (occurrences != null && occurrences.size() > 0) {
                this.m_occurrence = (VWTrkStepOccurrence)occurrences.elementAt(0);
            }
        } else if (this.m_selected instanceof VWTrkStepOccurrence) {
            this.m_occurrence = (VWTrkStepOccurrence)this.m_selected;
        }
        this.initParticipants();
        this.initResponses();
        this.updateCommentsAndResponse();
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 704: 
                case 705: {
                    Cursor currentCursor = null;
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.initData();
                    this.updateControls();
                    this.setCursor(currentCursor);
                    break;
                }
            }
        }
    }

    private void removePropertyChangeListener() {
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }

    public boolean isAnyActiveWork() {
        return this.m_activeSteps != null && this.m_activeSteps.size() > 0;
    }
}

